
<?php
// Fetch data from URL
$api_key = $_GET['api_key'] ?? '';
$receiver = $_GET['receiver'] ?? '';
$message = $_GET['message'] ?? '';

// Validation of received data
if (empty($api_key) || empty($receiver) || empty($message)) {
    echo "Be sure to use the api_key, receiver, message parameters. Make sure the value of the parameter is correct";
    exit;
}

// Setting up the body of the request
$body = [
    'api_key' => $api_key,
    'receiver' => $receiver,
    'data' => ['message' => $message]
];

// Make requests to the API
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'http://38.242.217.158:5570/api/send-message',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($body),
    CURLOPT_HTTPHEADER => [
        'Accept: */*',
        'Content-Type: application/json',
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo 'cURL Error #: ' . $err;
} else {
    echo $response;
}
?>
